package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.model.Buzon;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0476s00Service generated by UDA, 07-Feb-2017 13:06:26.
 * 
 * @author UDA
 */

public interface BuzonService {

	/**
	 * Inserts a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	Buzon add(Buzon ab0476s00);

	/**
	 * Updates a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	Buzon update(Buzon ab0476s00);

	/**
	 * Finds a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @return the buzon
	 */
	Buzon find(Buzon ab0476s00);

	/**
	 * Deletes a single row in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 */
	void remove(Buzon ab0476s00);

	/**
	 * Finds a list of rows in the Ab0476s00 table.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0476s00>
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<Buzon> findAll(Buzon ab0476s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0476s00 table using like.
	 * 
	 *  ab0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0476s00>
	 *
	 * @param ab0476s00 the ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Buzon> findAllLike(Buzon ab0476s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0476s00>
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<Buzon> filter(Buzon filterAb0476s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  searchAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0476s00>>
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param searchAb0476s00 the search ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Buzon>> search(Buzon filterAb0476s00,
			Buzon searchAb0476s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0476s00 table.
	 * 
	 *  filterAb0476s00
	 *            Ab0476s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0476s00 the filter ab 0476 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(Buzon filterAb0476s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Obtener buzon.
	 * 
	 *  procedureId            String
	 *  codTerritorio            String
	 *  Buzon
	 *
	 * @param procedureId the procedure id
	 * @param codTerritorio the cod territorio
	 * @return the buzon
	 */
	public Buzon obtenerBuzon(String procedureId, String codTerritorio);

	/**
	 * Obtener buzon osalan.
	 * 
	 *  codTerritorio            String
	 *  Buzon
	 *
	 * @param codTerritorio the cod territorio
	 * @return the buzon
	 */
	public Buzon obtenerBuzonOsalan(String codTerritorio);
}
